// Enc_Decoder固有のライブラリー
// メッセージ表示関係のクラス
class Message {
  // コンストラクター
  Message() {
  }
  void set(String msg) {
    set(msg, true, #000000);
  }
  // メッセージの表示
  void set(String msg, boolean flag, int col) {
    if (flag) write("〇");
    crowbar.textColor(col);
    writeln(msg);
    println(msg);
  }
  // エラーメッセージの表示
  void setError(String msg) {
    String label = "〇Error: "; 
    crowbar.textColor(#ff0000);
    write(label);
    set(msg, false, #000000);
    print(label);
  }
  // 警告メッセージの表示
  void setWarnning(String msg) {
    String label = "〇Warnning: "; 
    crowbar.textColor(#800080);
    write(label);
    set(msg, false, #000000);
    print(label);
  }
}

// Gokurakuシリーズ共通の関数ライブラリーの流用

//// 定数
final String JapaneseFont     = "Meiryo";

// システム依存のパス区切り子 (UNIX: /, Windwos: \\)
File _fp = new File("");
final String Separator = _fp.separator; 

//// 変換関係
// 浮動小数点を小数点以下n桁で切り捨てる関数
float floorN(float f, int n) {
  return float(floor(f * pow(10, n))) / pow(10, n);
}

//// ファイル関係のクラス
// CSV（カンマ区切りの浮動小数点数）のテキストを切り分けるクラス
class CsvStrings {
  String text;
  String str;
  float  value;
  // コンストラクター
  CsvStrings(String text) {
    this.set(text);
  }
  void set(String str) {
    text = str + ",";
    value     =  float("NaN");  // floatの形式ではないのでNaNになる
  }
  // 次の値を取得する：正常に終了したらtrueを返し，valueに値が設定される
  boolean next() {
    if (text.indexOf(",") == -1) return false;
    if (text.length() == 0)      return false;
    if (text.equals(","))        return false;
    str   = text.substring(0, text.indexOf(","));
    value = float(str);
    text  = text.substring(text.indexOf(",") + 1);
    return true;
  }
  boolean is_float() {
    if (value != value) return false;  // NaN, ちょっとトリッキーな方法
    return true;
  }
}
 //<>// //<>//
//// D&D関係
// 参考URL（ドラッグ＆ドロップに関して
// https://qiita.com/rain-lotus/items/258fa3defd41846bfd50
// https://sites.google.com/site/gutugutu30/other/processingdedoragguandodoroppu

import java.awt.datatransfer.*;  
import java.awt.dnd.*;  
import java.io.File;  
import java.io.IOException;  
import java.awt.Component;
import java.util.List;

DropTarget dropTarget;
Component  component;

void drop_init() {  
  component = (Component)this.surface.getNative();
  dropTarget = new DropTarget(component, new DropTargetListener() {
    public void dragEnter(DropTargetDragEvent dtde) {
    }  
    public void dragOver(DropTargetDragEvent dtde) {
    }  
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }  
    public void dragExit(DropTargetEvent dte) {
    }  
    public void drop(DropTargetDropEvent dtde) {  
      dtde.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);  
      Transferable trans = dtde.getTransferable();  
      List<File> fileNameList = null;  
      if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {  
        try {  
          fileNameList = (List<File>)  
            trans.getTransferData(DataFlavor.javaFileListFlavor);
        } 
        catch (UnsupportedFlavorException ex) {
        } 
        catch (IOException ex) {
        }
      }  
      if (fileNameList == null) return;  
      fileSelected(fileNameList);
    }
  }
  );
}

//// ドラッグ＆ドロップ関係
// 上記URL参照
// ドロップされたファイルの処理
void fileSelected(List<File> fs) {
  File [] fileList = {};
  File oneDirectory = null;  // 特例のための変数
  for (File f:fs) {
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は無視する
    if (f.isDirectory()) {
      oneDirectory = f;
      continue;
    }
    fileList = (File [])append(fileList, f);  // ListからArrayへ変更
  }
  if (fileList.length == 0) {
    // 特例として，D&Dで単一のフォルダーのみがDropされた時はフォルダーモードとして動作する
    if (oneDirectory != null) {
//    im_file.folderSelected(oneDirectory);
      return;
    }
    return;  // ファイルが一つも存在しなかった場合
  }
//im_file.open_files(fileList);
}

// クリップボード関係
// 引用元： https://romly.com/blog/processing_copy_to_clipboard/
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.StringSelection;
import java.awt.Toolkit;
void CopyToClipboard(String s)
{
    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    StringSelection data = new StringSelection(s);
    clipboard.setContents(data, data);
}
